package aufgabe3;

import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import java.awt.event.KeyEvent;

/**
 * Ein <code>Pong</code> stellt das Hauptprogramm des Spiels Pong dar,
 * in dem zwei {@link Schlaeger} und ein {@link Ball} erzeugt, miteinander
 * verknuepft und dargestellt werden.
 *
 */
public class Pong {

	public static void main(String[] args) {

		Frame fenster = new Frame("Simple pong based on GeoFaSC");
		fenster.setSize(300, 250);
		fenster.setCenterLocation();
		Canvas spielfeld = fenster.getCanvas();
		
		Schlaeger schlaegerLinks = new Schlaeger(20, 20, 20, 100, spielfeld);
		Schlaeger schlaegerRechts = new Schlaeger(200, 40, 20, 100, spielfeld);

		Ball ball = new Ball(75, 60, 15, spielfeld);
		ball.setFigureDirection(-15);

		TastaturEreignisBearbeiter b1 = new TastaturEreignisBearbeiter(schlaegerLinks,
				KeyEvent.VK_F, KeyEvent.VK_D);
		
		TastaturEreignisBearbeiter b2 = new TastaturEreignisBearbeiter(schlaegerRechts,
				KeyEvent.VK_J, KeyEvent.VK_K);
		
		ball.lerneSchlaegerKennen(schlaegerLinks);
		ball.lerneSchlaegerKennen(schlaegerRechts);
		
		fenster.addKeyListener(b1);
		fenster.addKeyListener(b2);
	
		ball.bewege();
		
		fenster.setVisible(true);
	}

}
