package aufgabe2;

import geofasc.swing.Rectangle;
import geofasc.swing.tool.Calculator;

import java.awt.Color;
import java.awt.FlowLayout;

/**
 * Eine <code>LEDBar</code> besteht aus einer Menge von {@link LED}s, die
 * rasterfoermig angeordnet sind. Eine solche Bar sorgt fuer das zufaellig
 * verteilte Blinken ihrer {@link LED}s.
 * 
 */
public class LEDBar extends Rectangle {

	private static final int sLedDiameter = 15;

	private LED[] mLeds;             // Array zum Speichern der Menge von Leds
	private Thread mLightningThread; // Thread zum nebenlaeufigen Blinken von Leds

	/**
	 * Erzeugt eine neue <code>LEDBar</code> bar.
	 * 
	 * @param x
	 *            die x-Koordinate von bar bez. ihres Eltercontainers
	 * @param y
	 *            die y-Koordinate von bar bez. ihres Eltercontainers
	 * @param rows
	 *            die Led-Zeilenanzahl von bar
	 * @param cols
	 *            die Led-Spaltenanzahl von bar
	 */
	public LEDBar(int x, int y, int rows, int cols) {
      // --------------------------
		// Ab HIER implementieren
		
         // Die Hintergrundfarbe einer LEDBar soll schwarz sein

      

		// Bis HIER implementieren
		// --------------------------

      setLayout(new FlowLayout(FlowLayout.CENTER, 2, 2));
	}

	/**
	 * Erzeugt die einzelnen Leds und fuegt diese rasterfoermig dieser LEDBar
	 * hinzu.
	 */
	private void fillWithLeds() {
      // --------------------------
		// Ab HIER implementieren

         // Die x-y-Koordinaten einer LED duerfen aufgrund des FlowLayouts
         // jeweils mit 0 angenommen werden. Die Aus-Farbe soll grau sein, die
         // An-Farbe soll zufaellig gewaehlt werden.



		// Bis HIER implementieren
		// --------------------------
	}

	/**
	 * Gibt eine zufaellig erzeugte Farbe wieder.
	 * 
	 * @return eine Farbe
	 */
	private Color getRandomColor() {
		Calculator calc = new Calculator();
		
		int r = calc.randomInt(0, 255);
		int g = calc.randomInt(0, 255);
		int b = calc.randomInt(0, 255);
		
		return new Color(r, g, b);
	}
	
	/**
	 * Startet das Blinken zufaellig ausgewaehlter LEDs.
	 */
	public void startBlinking() {

		if (mLightningThread == null) {

			mLightningThread = new Thread() {

				@Override
				public void run() {
					try {
						Calculator calc = new Calculator();
						
						while (true && !isInterrupted()) {
							// Bis hierher technischer Code
							
                     // --------------------------
		               // Ab HIER implementieren

                        // Zufaellig eine LED der LEDBar waehlen
                        // und schalten						

							
							
							// Bis HIER implementieren
							// --------------------------------------

                     sleep(calc.randomInt(20, 100));

							// Ab hier wieder technischer Code
						}
					} catch (InterruptedException e) {
					}
				}
			};
			mLightningThread.start();
		}
	}

	/**
	 * Stoppt das Blinken zufaellig ausgewaehlter LEDs.
	 */
	public void stopBlinking() {
		if (mLightningThread != null) {
			mLightningThread.interrupt();
			mLightningThread = null;
		}
	}

}
