/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'BasicPolylineUI.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.plaf;

import geofasc.swing.AbstractFigure;
import geofasc.swing.Polyline;
import geofasc.swing.model.PolylineModel;

import java.awt.Graphics;
import java.awt.Polygon;

import javax.swing.JComponent;

/**
 * Basic implementation of {@link PolylineUI}.
 * 
 * @version 0.1 08/11/10
 * @author Christian Wolf
 */
public class BasicPolylineUI extends PolylineUI {

	/** {@inheritDoc} */
	@Override
	public boolean contains(JComponent c, int x, int y) {

		PolylineModel polygonModel = ((Polyline) c).getModel();
		java.awt.Polygon awtPolygon = (polygonModel != null ? polygonModel
				.toAWTPolygon() : null);

		if (awtPolygon != null)
			return awtPolygon.contains(x, y);
		else
			return super.contains(c, x, y);
	}

	/** {@inheritDoc} */
	@Override
	protected void paintFigure(Graphics g, AbstractFigure f) {

		PolylineModel polylineModel = ((Polyline) f).getModel();

		if (polylineModel == null || !f.isVisible())
			return;

		if (polylineModel.isClosed()) {
			// draw a polygon
			if (polylineModel.isFilled()) {
				g.setColor(polylineModel.getFillColor());
				g.fillPolygon(polylineModel.toAWTPolygon());
			} else {
				g.setColor(polylineModel.getLineColor());
				g.drawPolygon(polylineModel.toAWTPolygon());
			}
		} else {
			// draw a polyline
			g.setColor(polylineModel.getLineColor());
			Polygon polygon = polylineModel.toAWTPolygon();
			g.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
		}

	}

}
