/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'EllipseModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;


/**
 * <code>EllipseModel</code> is the interface for the data model of an
 * ellipse figure. This interface is inherited from
 * {@link FigureModelExtended}. </p>
 * 
 * An ellipse is defined by its width and height of its axes (see
 * {@link FigureModelExtended#getSize()},
 * {@link FigureModelExtended#setSize(int, int)}). Besides the common visual
 * properties some extra ones can be set on it like drawing rounded corners.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * @see FigureModelExtended
 * 
 */
public interface EllipseModel extends FigureModelExtended {

}
