/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'DefaultLineSegmentModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

/**
 * <code>DefaultLineSegmentModel</code> is the default implementation of
 * {@link LineSegmentModel}. This class is inherited from
 * {@link DefaultFigureModel}.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public class DefaultLineSegmentModel extends DefaultFigureModel implements
		LineSegmentModel {

	private int mFirstPointX;
	private int mFirstPointY;
	private int mSecondPointX;
	private int mSecondPointY;

	/** {@inheritDoc} */
	@Override
	public Point getFirstPoint() {
		return new Point(mFirstPointX, mFirstPointY);
	}

	/** {@inheritDoc} */
	@Override
	public int getFirstPointX() {
		return mFirstPointX;
	}

	/** {@inheritDoc} */
	@Override
	public int getFirstPointY() {
		return mFirstPointY;
	}

	/** {@inheritDoc} */
	@Override
	public int getLength() {
		int width = Math.abs(mFirstPointX - mSecondPointX);
		int height = Math.abs(mFirstPointY - mSecondPointY);
		return (int) Math.sqrt(width * width + height * height);
	}

	/** {@inheritDoc} */
	@Override
	public Point getSecondPoint() {
		return new Point(mSecondPointX, mSecondPointY);
	}

	/** {@inheritDoc} */
	@Override
	public int getSecondPointX() {
		return mSecondPointX;
	}

	/** {@inheritDoc} */
	@Override
	public int getSecondPointY() {
		return mSecondPointY;
	}

	/** {@inheritDoc} */
	@Override
	public boolean isFilled() {
		return false;
	}

	/** {@inheritDoc} */
	@Override
	public void setFirstPoint(int x, int y) {
		if (x == mFirstPointX && y == mFirstPointY)
			return;

		mFirstPointX = x;
		mFirstPointY = y;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setFirstPoint(Point firstPoint) {
		if (firstPoint != null)
			setFirstPoint(firstPoint.x, firstPoint.y);
	}

	/** {@inheritDoc} */
	@Override
	public void setFirstPointX(int x) {
		if (x == mFirstPointX)
			return;

		mFirstPointX = x;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setFirstPointY(int y) {
		if (y == mFirstPointY)
			return;

		mFirstPointY = y;
		fireStateChanged();
	}

	// /** {@inheritDoc} */
	// @Override
	// public void setLength(int length) {
	//
	// // System.out.println(getLength());
	// //
	// // Point a = getFirstPoint();
	// // Point b = getSecondPoint();
	// //
	// // if (a == null || b == null || a.equals(b))
	// // return;
	// // else if (a.x == b.x) {
	// // setSecondPoint(a.x, a.y + length);
	// // } else if (a.y == b.y) {
	// // setSecondPoint(a.x + length, a.y);
	// // } else {
	// // double dLength = length - getLength();
	// // double width_ = getSecondPointX() - getFirstPointX();
	// // double height_ = getSecondPointY() - getFirstPointY();
	// //
	// // double dWidth = width_ * dLength / getLength();
	// // double dHeight = Math.sqrt((getLength() + dLength)
	// // * (getLength() + dLength) - (width_ + dWidth)
	// // * (width_ + dWidth));
	// //
	// // setSecondPoint(getFirstPointX() + (int) Math.round(width_) + (int)
	// // Math.round(dWidth),
	// // getFirstPointY() + (int) Math.round(dHeight));
	// //
	// // System.out.println(getLength() + " \n");
	// //
	// // }
	//
	// }

	/** {@inheritDoc} */
	@Override
	public void setSecondPoint(int x, int y) {
		if (x == mSecondPointX && y == mSecondPointY)
			return;

		mSecondPointX = x;
		mSecondPointY = y;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setSecondPoint(Point secondPoint) {
		if (secondPoint != null)
			setSecondPoint(secondPoint.x, secondPoint.y);
	}

	/** {@inheritDoc} */
	@Override
	public void setSecondPointX(int x) {
		if (x == mSecondPointX)
			return;

		mSecondPointX = x;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setSecondPointY(int y) {
		if (y == mSecondPointY)
			return;

		mSecondPointY = y;
		fireStateChanged();
	}

	@Override
	public Rectangle getBounds() {
		return new Rectangle(getLocation(), new Dimension(Math.max(
				mFirstPointX, mSecondPointX), Math.max(mFirstPointY,
				mSecondPointY)));
	}

}
