/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'CircleModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

/**
 * <code>CircleModel</code> is the interface for the data model of a circle
 * figure. This interface is inherited from {@link EllipseModel}.</p>
 * 
 * A circle is defined by its radius.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public interface CircleModel extends EllipseModel {

	/**
	 * Gets the diameter of this model's circle.
	 * 
	 * @return the current radius
	 */
	int getDiameter();
	
	/**
	 * Gets the radius of this model's circle.
	 * 
	 * @return the current radius
	 */
	int getRadius();

	/**
	 * Sets the diameter of of this model's circle.
	 * 
	 * @param radius
	 *            the new radius
	 */
	void setDiameter(int diameter);
	
	/**
	 * Sets the radius of of this model's circle.
	 * 
	 * @param radius
	 *            the new radius
	 */
	void setRadius(int radius);

}
