/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Pencil.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package geofasc.swing.demo;

import geofasc.swing.tool.ComponentMouseDragger;
import geofasc.swing.tool.Frame;

/**
 * 
 * @author Christian Wolf
 *
 */
public class WindradParkDemo {

	// Attribute

	private Windrad windrad1, windrad2, windrad3;

	// Konstruktoren
	
	/**
	 * Erzeugt ein neues WindradPark-Objekt.
	 */
	public WindradParkDemo() {
		windrad1 = new Windrad(0, 0, 0);
		windrad2 = new Windrad(200, 40, 45);
		windrad3 = new Windrad(400, 80, 90);
		
		ComponentMouseDragger.register(windrad1);
		ComponentMouseDragger.register(windrad2);
		ComponentMouseDragger.register(windrad3);
	}

	// Methoden
	
	/**
	 * Startet das Rotieren der Windräder.
	 */
	public void starteRotieren() {
		windrad1.starteRotieren();
		windrad2.starteRotieren();
		windrad3.starteRotieren();
	}

	/**
	 * Stoppt das Rotieren der Windräder.
	 */
	public void stoppeRotieren() {
		windrad1.stoppeRotieren();
		windrad2.stoppeRotieren();
		windrad3.stoppeRotieren();
	}

	/**
	 * Visualisiert den WindradPark in einem Fenster mit einer Zeichenfläche.
	 */
	public void zeige() {
		Frame fenster = new Frame("Windradpark");
		fenster.getCanvas().add(windrad1, windrad2, windrad3);
		fenster.setVisible(true);
	}

	public static void main(String[] args) {
		WindradParkDemo windradpark = new WindradParkDemo();
		windradpark.zeige();

		while (true) {
			windradpark.starteRotieren();
			Windrad.verzoegere(20000);
			windradpark.stoppeRotieren();
			Windrad.verzoegere(8000);
		}

	}

}
