/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'FigureDemo.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import geofasc.swing.Polyline;
import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/**
 * <code>SimplePaintDemo</code> is a small demo enabling painting with the
 * mouse.
 * 
 * @author Christian Wolf
 * 
 */
@SuppressWarnings("serial")
public class SimplePaintDemo extends Frame {

	public SimplePaintDemo(String title) throws HeadlessException {
		super(title);
	}

	public void demo() {

		final Canvas canvas = getCanvas();
		final Polyline firstPolyline = new Polyline();
		canvas.add(firstPolyline);

		MouseAdapter mousePainter = new MouseAdapter() {

			Polyline polyline = firstPolyline;

			@Override
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() > 1) {
					canvas.removeAll();
					canvas.repaint();
					polyline = new Polyline();
					canvas.add(polyline);
				}
			}

			@Override
			public void mouseDragged(MouseEvent e) {
				if (e.getSource() instanceof JComponent) {
					JComponent comp = (JComponent) e.getSource();
					Point p = e.getPoint();
					p = SwingUtilities.convertPoint(comp, p, polyline);
					polyline.addPoint(p);
				}
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				polyline = new Polyline();
				canvas.add(polyline);
			}

		};
		canvas.addMouseMotionListener(mousePainter);
		canvas.addMouseListener(mousePainter);

	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				SimplePaintDemo frame = new SimplePaintDemo(
						"Mouse painting demo based on GeoFaSC");
				frame.setCenterLocation();
				frame.setVisible(true);
				frame.demo();
			}
		});

	}

}
