package geofasc.swing;

import geofasc.swing.model.DefaultPointModel;
import geofasc.swing.model.FigureModel;
import geofasc.swing.model.PointModel;
import geofasc.swing.plaf.BasicPointUI;
import geofasc.swing.plaf.PointUI;
import geofasc.swing.plaf.RectangleUI;

import javax.swing.UIManager;

/**
 * <code>Point</code> is the component used for visualizing a point
 * figure. See {@link PointModel} for more information on how a point
 * figure is represented. This class is inherited from {@link AbstractFigure}.
 * 
 * @version 0.1 08/11/10
 * @author Christian Wolf
 * @see DefaultPointModel
 * @see PointUI
 * @see BasicPointUI
 * 
 */
@SuppressWarnings("serial")
public class Point extends AbstractFigure {

	private static final String uiClassID = "PointUI";

	/**
	 * Constructs a new <code>Point</code> at <code>(x,y)</code> -location
	 * <code>(0,0)</code>.
	 */
	public Point() {
		this(0, 0);
	}

	/**
	 * Constructs a new <code>Circle</code> at location <code>(x,y)</code> .
	 * 
	 * @param x
	 *            the initial x-location
	 * @param y
	 *            the initial y-location
	 */
	public Point(int x, int y) {
		super(x, y);
	}

	@Override
	protected FigureModel createDefaultModel() {
		return new DefaultPointModel();
	}

	/** {@inheritDoc} */
	@Override
	public PointUI getUI() {
		return (PointUI) ui;
	}

	/** {@inheritDoc} */
	@Override
	public String getUIClassID() {
		return uiClassID;
	}

	/**
	 * Sets the look and feel (L&F) object that renders this point.
	 * 
	 * @param ui
	 *            the new L&F object
	 */
	public void setUI(PointUI ui) {
		super.setUI(ui);
	}

	/** {@inheritDoc} */
	@Override
	public void updateUI() {
		if (UIManager.get(getUIClassID()) != null) {
			setUI((RectangleUI) UIManager.getUI(this));
		} else {
			setUI(new BasicPointUI());
		}
	}

}
