/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'BasicRectangleUI.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.plaf;

import geofasc.swing.AbstractFigure;
import geofasc.swing.Rectangle;
import geofasc.swing.model.RectangleModel;

import java.awt.Graphics;


/**
 * Basic implementation of {@link RectangleUI}.
 *
 * @version 0.1 08/11/10
 * @author Christian Wolf
 */
public class BasicRectangleUI extends RectangleUI {

	/** {@inheritDoc} */
	@Override
	protected void paintFigure(Graphics g, AbstractFigure f) {

		RectangleModel rectModel = ((Rectangle) f).getModel();

		if (rectModel == null || !f.isVisible())
			return;

		int width = rectModel.getWidth();
		int height = rectModel.getHeight();
		int arcHeight = rectModel.getArcHeight();
		int arcWidth = rectModel.getArcWidth();

		// draw (rounded) rectangle
		g.setColor(rectModel.getLineColor());
		if (!rectModel.hasRoundedCorners())
			g.drawRect(0, 0, width, height);
		else
			g.drawRoundRect(0, 0, width, height, arcWidth, arcHeight);

		// possibly fill rectangle
		if (rectModel.isFilled()) {
			g.setColor(rectModel.getFillColor());
			if (!rectModel.hasRoundedCorners())
				g.fillRect(1, 1, width - 1, height - 1);
			else
				g.fillRoundRect(1, 1, width - 1, height - 1, arcWidth,
						arcHeight);
		}

	}

}
