/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Swarm.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import java.awt.HeadlessException;

import geofasc.swing.Point;
import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import javax.swing.SwingUtilities;

/**
 * <code>BuzzingInsectsDemo</code> is a simple demo using multiple {@link Point}
 * s to simulate buzzing insects.
 * 
 * @author Christian Wolf
 * 
 */
@SuppressWarnings("serial")
public class BuzzingInsectsDemo extends Frame {

	public BuzzingInsectsDemo(String title) throws HeadlessException {
		super(title);
	}

	public void demo() {

		final geofasc.swing.Point[] insects = new geofasc.swing.Point[100];
		int x, y;
		Canvas canvas = getCanvas();

		for (int i = 0; i < 100; i++) {
			x = (int) ((Math.random() * 1000.) % getWidth()-10);
			y = (int) ((Math.random() * 1000.) % getHeight()-10);

			insects[i] = new geofasc.swing.Point(x, y);
			canvas.add(insects[i]);
		}

		Thread buzzingThread = new Thread() {

			@Override
			public void run() {

				try {
					int dx, dy;

					while (true) {
						for (int i = 0; i < 100; i++) {
							dx = (int) ((Math.random() * 10.) % 7);
							dy = (int) ((Math.random() * 10.) % 7);

							if (Math.random() <= 0.5)
								dx *= -1;

							if (Math.random() <= 0.5)
								dy *= -1;

							insects[i].moveFigureLocationBy(dx, dy);
						}
						sleep(50);
					}
				}// try
				catch (Exception e) {
				}

			} // run

		};
		buzzingThread.start();

	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				BuzzingInsectsDemo frame = new BuzzingInsectsDemo(
						"Buzzing insects demo based on GeoFaSC");
				frame.setCenterLocation();
				frame.setVisible(true);
				frame.demo();
			}
		});

	}

}
