package geofasc.swing.plaf;

import geofasc.swing.AbstractFigure;
import geofasc.swing.Point;
import geofasc.swing.model.FigureModel;

import java.awt.Graphics;

/**
 * Basic implementation of {@link PointUI}.
 *
 * @version 0.1 08/16/10
 * @author Christian Wolf
 */
public class BasicPointUI extends PointUI {

	/** {@inheritDoc} */
	@Override
	protected void paintFigure(Graphics g, AbstractFigure f) {
		
		FigureModel pointModel = ((Point) f).getModel();

		if (pointModel == null || !f.isVisible())
			return;
		
		g.setColor(pointModel.getLineColor());
		g.drawRect(0, 0, pointModel.getWidth(), pointModel.getHeight());	
	}
	
}
