/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'BasicEllipseUI.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.plaf;

import geofasc.swing.AbstractFigure;
import geofasc.swing.Ellipse;
import geofasc.swing.model.EllipseModel;

import java.awt.Graphics;

import javax.swing.JComponent;


/**
 * Basic implementation of {@link EllipseUI}.
 *
 * @version 0.1 08/11/10
 * @author Christian Wolf
 */
public class BasicEllipseUI extends EllipseUI {

	/** {@inheritDoc} */
	@Override
	public boolean contains(JComponent c, int x, int y) {
	
		EllipseModel ellipseModel = ((Ellipse) c).getModel();
		
		double a = ellipseModel.getWidth()/2;
		double b = ellipseModel.getHeight()/2;
		double centerX = a;
		double centerY = b;
		
		double f = ((x-centerX)*(x-centerX))/(a*a) + 
					((y-centerY)*(y-centerY))/(b*b);
		
		return (x>=0) && (y>=0) && (f <= 1.);
	}
	
	/** {@inheritDoc} */
	@Override
	protected void paintFigure(Graphics g, AbstractFigure f) {
		
		EllipseModel ellipseModel = ((Ellipse) f).getModel();

		if (ellipseModel == null || !f.isVisible())
			return;

		if (ellipseModel.isFilled() && ellipseModel.getLineColor().equals(ellipseModel.getFillColor()) ) {
			g.setColor(ellipseModel.getFillColor());
			g.fillOval(0, 0, ellipseModel.getWidth(), ellipseModel.getHeight());
			return;
		}
		
		// draw outer ellipse
		g.setColor(ellipseModel.getLineColor());
		g.drawOval(0, 0, ellipseModel.getWidth(), ellipseModel.getHeight());
		
		// possibly fill ellipse
		if (ellipseModel.isFilled())	{
			g.setColor(ellipseModel.getFillColor());
			g.fillOval(1, 1, ellipseModel.getWidth() - 2, ellipseModel.getHeight() - 2);
		}
		
	}
	
}
