/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'DefaultCircleModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

/**
 * <code>DefaultCircleModel</code> is the default implementation of
 * {@link CircleModel}. This class is inherited from {@link DefaultEllipseModel}.
 * 
 * @version 0.11 28/11/10
 * @author Christian Wolf
 *
 */
public class DefaultCircleModel extends DefaultEllipseModel implements
		CircleModel {

	/** {@inheritDoc} */
	@Override
	public int getRadius() {
		return getDiameter()/2;
	}

	/** {@inheritDoc} */
	@Override
	public void setRadius(int radius) {
		setDiameter(2*radius);
	}

	/** {@inheritDoc} */
	@Override
	public void setSize(int width, int height) {
		if (width == height) 
			super.setSize(width, height);
	}

	/** {@inheritDoc} */
	@Override
	public int getDiameter() {
		return getWidth();
	}

	/** {@inheritDoc} */
	@Override
	public void setDiameter(int diameter) {
		setSize(diameter, diameter);
	}
	
	
}
