/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'FlyingBullets.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import java.awt.HeadlessException;

import geofasc.swing.Circle;
import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import javax.swing.SwingUtilities;

/**
 * <code>FlyingBulletsDemo</code> is a small demo showing bullets flying around
 * and bouncing on this frame's bounds. It also demonstrates using the direction
 * of a geofasc component.
 * 
 * @author Christian Wolf
 * 
 */
@SuppressWarnings("serial")
public class FlyingBulletsDemo extends Frame {

	public FlyingBulletsDemo(String title) throws HeadlessException {
		super(title);
	}

	public void demo() {

		final Canvas canvas = getCanvas();
		final Circle[] bullets = new Circle[30];

		double dir = 13;
		int x, y;
		for (int i = 0; i < bullets.length; i++, dir += 11) {
			x = (int) ((Math.random() * 1000.) % 350);
			y = (int) ((Math.random() * 1000.) % 250);
			
			bullets[i] = new Circle(x, y, 30);
			bullets[i].setFigureDirection(dir);
			canvas.add(bullets[i]);
		}

		Thread bulletsMover = new Thread() {

			@Override
			public void run() {

				try {

					while (true) {

						for (int i = 0; i < bullets.length; i++) {

							final Circle bullet = bullets[i];
							final int x = bullet.getFigureLocationX();
							final int y = bullet.getFigureLocationY();
							final double dir = bullet.getFigureDirection();

							if (y <= 0
									|| (y + bullet.getFigureHeight()) >= getCanvas()
											.getHeight()) {
								bullet.setFigureDirection(360 - dir);
							} else if (x <= 0
									|| (x + bullet.getFigureWidth()) >= getCanvas()
											.getWidth()) {
								bullet.setFigureDirection(180 - dir);
							}

							bullet.moveFigureLocationBy(5);
						}

						sleep(50);
					}
				}// try
				catch (Exception e) {
				}

			} // run

		};
		bulletsMover.start();

	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				FlyingBulletsDemo frame = new FlyingBulletsDemo(
						"Demo of flying bullets based on GeoFaSC");
				frame.setCenterLocation();
				frame.setVisible(true);
				frame.demo();
			}
		});

	}

}
