/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Swarm.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import geofasc.swing.tool.Calculator;
import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import java.awt.HeadlessException;

@SuppressWarnings("serial")
public class Dictatorship extends Frame {

	private Calculator mCalc = new Calculator();
	private Person[][] mVoters = new Person[50][50];

	public Dictatorship(String title) throws HeadlessException {
		super(title);
	}

	public void demo() {
		Canvas canvas = this.getCanvas();
		for (int i = 0; i < mVoters.length; i++) {
			for (int j = 0; j < mVoters[i].length; j++) {
				mVoters[i][j] = new Person(i * 12, j * 12, mCalc.randomInt(1,
						100) <= 50);
			}
			canvas.add(mVoters[i]);
		}
		
		for (int i = 0; i < 10000; i++) {
			simulateClock();
			delay(30);
		}
	}

	public void simulateClock() {

		/*
		 * Algorithm based on the task 'Demokratur' in B. Schriek: Informatik
		 * mit Java - Eine Einführung mit der BlueJ und der Bibliothek Stifte
		 * und Mäuse, Band II:
		 * 
		 * 1. Random choice of a person P with adress (pi,pj).
		 * 
		 * 2. Random choice of a neighbour N of P with number 1...8 and adress
		 * (ni,nj).
		 * 
		 * If adress (ni, nj) does exist:
		 * 
		 * 3. Random choice of whom will be convinced: either P convinces N or
		 * vice versa.
		 * 
		 * 4. P (N) convinces N (P).
		 */

		int pi, pj, ni, nj;

		// 1.
		pi = mCalc.randomInt(0, 49);
		pj = mCalc.randomInt(0, 49);
		ni = 0;
		nj = 0;

		// 2.
		int neighbourNo = mCalc.randomInt(1, 8);

		if (neighbourNo == 1) {
			ni = pi - 1;
			nj = pj - 1;
		} else if (neighbourNo == 2) {
			ni = pi;
			nj = pj - 1;
		} else if (neighbourNo == 3) {
			ni = pi + 1;
			nj = pj - 1;
		} else if (neighbourNo == 4) {
			ni = pi - 1;
			nj = pj;
		} else if (neighbourNo == 5) {
			ni = pi + 1;
			nj = pj;
		} else if (neighbourNo == 6) {
			ni = pi - 1;
			nj = pj + 1;
		} else if (neighbourNo == 7) {
			ni = pi;
			nj = pj + 1;
		} else if (neighbourNo == 8) {
			ni = pi + 1;
			nj = pj + 1;
		}

		// 3. und 4.
		if (ni >= 0 && ni < mVoters.length && nj >= 0 && nj < mVoters[0].length) {

			if (mCalc.randomInt(0, 1) == 0) // P convinces N
				mVoters[ni][nj].setRed(mVoters[pi][pj].isRed());
			else
				// N convinces P
				mVoters[pi][pj].setRed(mVoters[ni][nj].isRed());
		}

	}

	private static void delay(int millis) {
		try {
			Thread.sleep(millis);
		} catch (Exception e) {
		}
	}

	public static void main(String[] args) {
		Dictatorship frame = new Dictatorship(
				"Dictatorship simulation based on GeoFaSC");
		frame.setSize(640, 720);
		frame.setCenterLocation();
		frame.setVisible(true);
		frame.demo();
	}

}
